//  
//  readIni.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System.IO;

namespace LFSLapper
{
    class readIni
    {
        public string password = "";
        public string configFile = "";
        public string superUsers = "";
        public readIni(string pWorkinfDir, string pIniFile)
        {
            string fileIni = pWorkinfDir + "/" + pIniFile;
            StreamReader sr = new StreamReader(fileIni);
            while (!sr.EndOfStream)
            {
                string line = sr.ReadLine();
                if (line.Trim() == "")
                    continue;
                if (line[0] == '#')
                    continue;
                try
                {
                    string[] arg = line.Split('=');
                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$password")
                        this.password = arg[1].Replace(';',' ').Replace('"',' ').Trim();

                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$configfile")
                        this.configFile = arg[1].Replace(';', ' ').Replace('"', ' ').Trim();

                    if (arg.Length > 1 && arg[0].ToString().ToLower().Trim() == "$superusersfile")
                        this.superUsers = arg[1].Replace(';', ' ').Replace('"', ' ').Trim();
                }
                catch
                {
                    throw (new System.Exception("Error in " + pIniFile + " config file: wrong format"));
                }
            }
            sr.Close();
        }
    }
}
